//+++======================================================================+++
//+++                   Triline 3 MTF TT [x2x2x3x4x1]                      +++
//+++======================================================================+++
#property copyright   "  Tankk,  24  August  2016,  http://forexsystems.ru/" 
#property link        "http://forexsystemsru.com/indikatory-foreks-f41/" 
#property description "    High/Low,    ." 
#property description " 1-2    !" 
#property description "*****************************************************************************************************"
#property description " MTF, 2 , 2  , 3  , 4     :))"
#property description " ++  Moving Average   :))"
#property version "3.0"
//#property strict

#property indicator_separate_window
#property indicator_buffers 6

#property indicator_color1  LimeGreen
#property indicator_color2  Green      //RoyalBlue    //Blue
#property indicator_color3  Red        //OrangeRed    //Red
#property indicator_color4  Tomato
#property indicator_color5  Gold
#property indicator_color6  LightSteelBlue  //LightCyan

#property indicator_width1  2
#property indicator_width2  2
#property indicator_width3  2
#property indicator_width4  2
#property indicator_width5  3
#property indicator_width6  2

#property indicator_level1 0
#property indicator_levelcolor DarkSlateGray // SteelBlue //C'60,61,62' // 
#property indicator_levelstyle STYLE_DOT
//#property indicator_level2 -2
//#property indicator_level3  2
//#property indicator_level4 -1
//#property indicator_level5  1

//#property indicator_minimum -1
//#property indicator_maximum 1

enum cycl { CyclePlus, CycleMinus };
enum calc { Triline2, GRAAL };
enum show { Line, Tape, Histo };
//+++======================================================================+++
//+++                 Custom indicator input parameters                    +++
//+++======================================================================+++

extern ENUM_TIMEFRAMES TimeFrame  =  PERIOD_CURRENT;
extern cycl                Cycle  =  CyclePlus;
extern calc          Calculation  =  GRAAL;
extern bool              Reverse  =  false;
extern int            HiLoPeriod  =  18;
extern show                 Show  =  Histo;
extern bool           ShowSignal  =  true;
extern int          SignalPeriod  =  12;
extern ENUM_MA_METHOD SignalMode  =  MODE_LWMA;

//+++======================================================================+++
//+++                     Custom indicator buffers                         +++
//+++======================================================================+++
double upZLupper[], upZLlower[], dnZLlower[], dnZLupper[], MAIN[], MAARR[];
//+++======================================================================+++
//+++              Custom indicator initialization function                +++
//+++======================================================================+++

int init()
{
   IndicatorBuffers(6);   //IndicatorDigits(Digits);   //if (Digits==2 || Digits==3) IndicatorDigits(Digits-1);
   
   SetIndexBuffer(0,upZLupper);
   SetIndexBuffer(1,upZLlower);
   SetIndexBuffer(2,dnZLlower);
   SetIndexBuffer(3,dnZLupper);
   SetIndexBuffer(4,MAIN);
   SetIndexBuffer(5,MAARR);
   
   int CLLT=DRAW_NONE;   if (Show==Tape || Show==Histo) CLLT=DRAW_HISTOGRAM;   
   SetIndexStyle(0,CLLT);   
   SetIndexStyle(1,CLLT);   
   SetIndexStyle(2,CLLT);   
   SetIndexStyle(3,CLLT);
   
   int MNLT=DRAW_LINE;   if (Show==Tape || Show==Histo) MNLT=DRAW_NONE;   
   SetIndexStyle(4,MNLT);
   SetIndexStyle(5,DRAW_LINE);
   
//---- names for DataWindow and indicator subwindow labels
   if (Show==Tape || Show==Histo) { SetIndexLabel(0,">>0 Upper");   SetIndexLabel(1,">>0 Lower");   SetIndexLabel(2,"<<0 Lower");   SetIndexLabel(3,"<<0 Upper"); }
   else { SetIndexLabel(0,NULL);   SetIndexLabel(1,NULL);   SetIndexLabel(2,NULL);   SetIndexLabel(3,NULL); }
   
   SetIndexLabel(4,EnumToString(Calculation)+" ["+IntegerToString(HiLoPeriod)+"]");
   
   if ((ShowSignal) && (Show!=Tape)) SetIndexLabel(5,"SignalMA ["+IntegerToString(SignalPeriod)+"]");   else SetIndexLabel(5,NULL);
   
   if (Cycle==0) string CYCL="[C++]";   else CYCL="[C--]";
   if (Reverse) string RVRS="Reverse";   else RVRS="Standart";
   IndicatorShortName(string_per(TimeFrame)+" = "+CYCL+" "+EnumToString(Calculation)+"-"+RVRS+ " ["+IntegerToString(HiLoPeriod)+"]");
   
//---//---//---
return(0);
}
//+++======================================================================+++
//+++              Custom indicator deinitialization function              +++
//+++======================================================================+++
int deinit() { return (0); }
//+++======================================================================+++
//+++                 Custom indicator iteration function                  +++
//+++======================================================================+++

int start()
{
   int i, y, limit, counted_bars=IndicatorCounted();
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;

   double Value=0, Value1=0, Fish=0;  //Value2=0, Fish=0, Fish1=0, Fish2=0;
   double BarValue, Median, MinL=0, MaxH=0;
   double rvrs=-1;   if (Reverse) rvrs=1;
//+++======================================================================+++

 if (Cycle==CyclePlus) 
  {  
   for (i=0; i<limit; i++)   //for (i=limit; i>=0; i--)
     {
      y = iBarShift(NULL,TimeFrame,Time[i],false);
      //MaxH = High[iHighest(NULL,0,MODE_HIGH,period,i)];        // 
      //MinL = Low[iLowest(NULL,0,MODE_LOW,period,i)];           // 
      //price = (High[i]+Low[i])/2;                              // 
      MaxH = iHigh(NULL,TimeFrame,iHighest(NULL,TimeFrame,MODE_HIGH,HiLoPeriod,y));       //       period
      MinL = iLow(NULL,TimeFrame,iLowest(NULL,TimeFrame,MODE_LOW,HiLoPeriod,y));          //       period
      Median = (iHigh(NULL,TimeFrame,y) + iLow(NULL,TimeFrame,y)) /2;                     //     

      if (MaxH-MinL==0) Value = 0.33*2*(0-0.5) + 0.67*Value1;
      else Value = 0.33*2*((Median-MaxH)/(MinL-MaxH)-0.5) + 0.67*Value1;

      Value=MathMin(MathMax(Value,-0.999),0.999);
      
      if (Calculation==Triline2) 
       {
        if (1-Value==0) MAIN[i] = (0.5+0.5*Fish)*(rvrs);
        else MAIN[i] = (0.5*MathLog((1+Value)/(1-Value))+0.5*Fish)*(rvrs);
       }
       
      if (Calculation==GRAAL) 
       {
        if (1-Value==0) MAIN[i] = - 0.5+0.5*Fish;
        else MAIN[i] = - 0.5*MathLog((1+Value)/(1-Value))+0.5*Fish;
        
        if (Reverse) {
        if (1-Value==0) MAIN[i] = 0.5+0.5*Fish;
        else MAIN[i] = 0.5*MathLog((1+Value)/(1-Value))+0.5*Fish; }
       }      

      Value1=Value;
      Fish=MAIN[i];
//---//---//--- * * for (i=0; i<limit; i++)
    }  
  }    
//+++======================================================================+++
//+++                   Triline 3 MTF TT [x2x2x3x4x1]                      +++
//+++======================================================================+++  

 if (Cycle==CycleMinus) 
  {  
   for (i=limit; i>=0; i--)   //for (i=0; i<limit; i++)   //
     {
      y = iBarShift(NULL,TimeFrame,Time[i],false);

      MaxH = iHigh(NULL,TimeFrame,iHighest(NULL,TimeFrame,MODE_HIGH,HiLoPeriod,y));       //       period
      MinL = iLow(NULL,TimeFrame,iLowest(NULL,TimeFrame,MODE_LOW,HiLoPeriod,y));          //       period
      Median = (iHigh(NULL,TimeFrame,y) + iLow(NULL,TimeFrame,y)) /2;                     //     

      if (MaxH-MinL==0) Value = 0.33*2*(0-0.5) + 0.67*Value1;
      else Value = 0.33*2*((Median-MaxH)/(MinL-MaxH)-0.5) + 0.67*Value1;

      Value=MathMin(MathMax(Value,-0.999),0.999);
      
      if (Calculation==Triline2) 
       {
        if (1-Value==0) MAIN[i] = (0.5+0.5*Fish)*(rvrs);
        else MAIN[i] = (0.5*MathLog((1+Value)/(1-Value))+0.5*Fish)*(rvrs);
       }
       
      if (Calculation==GRAAL) 
       {
        if (1-Value==0) MAIN[i] = - 0.5+0.5*Fish;
        else MAIN[i] = - 0.5*MathLog((1+Value)/(1-Value))+0.5*Fish;
        
        if (Reverse) {
        if (1-Value==0) MAIN[i] = 0.5+0.5*Fish;
        else MAIN[i] = 0.5*MathLog((1+Value)/(1-Value))+0.5*Fish; }
       }      

      Value1=Value;
      Fish=MAIN[i];
//---//---//--- * * for (i=limit; i>=0; i--)
    }  
  }    
//+++======================================================================+++
//+++                   Triline 3 MTF TT [x2x2x3x4x1]                      +++
//+++======================================================================+++
//enum show { Line, Tape, Histo };   //double upZLupper[], upZLlower[], dnZLlower[], dnZLupper[]; 
   for (i=limit; i>=0; i--)
    {
     if ((ShowSignal) && (Show!=Tape)) { MAARR[i] = iMAOnArray(MAIN,0,SignalPeriod,0,SignalMode,i); }
     
     switch(Show)
      {
       case Line  : BarValue = MAIN[i]; break;
       case Tape  : BarValue = 1;       break;
       case Histo : BarValue = MAIN[i]; break;
      }
//+++======================================================================+++
     if (MAIN[i] > 0 && MAIN[i] > MAIN[i+1])   //both up
      {
       upZLupper[i] = BarValue;
       upZLlower[i] = 0;
       dnZLlower[i] = 0;
       dnZLupper[i] = 0;
      }
     
     if (MAIN[i] > 0 && MAIN[i] < MAIN[i+1])   //main up && main lower
      {
       upZLupper[i] = 0;
       upZLlower[i] = BarValue;
       dnZLlower[i] = 0;
       dnZLupper[i] = 0;
      }    
        
     if (MAIN[i] < 0 && MAIN[i] < MAIN[i+1])   //both down
      {
       upZLupper[i] = 0;
       upZLlower[i] = 0;
       dnZLlower[i] = BarValue;
       dnZLupper[i] = 0;
      }
      
     if (MAIN[i] < 0 && MAIN[i] > MAIN[i+1])   //main down && main upper
      {
       upZLupper[i] = 0;
       upZLlower[i] = 0;
       dnZLlower[i] = 0;
       dnZLupper[i] = BarValue;
      }      
//---//---//--- * * for (i=limit; i>=0; i--)
     }
//---//---//---
return(0);
}
//+++======================================================================+++
//+++======================================================================+++
string string_per(int per)
  {
   if (per == 0)     per=Period();
   if (per == 1)     return("M1");
   if (per == 5)     return("M5");
   if (per == 15)    return("M15");
   if (per == 30)    return("M30");
   if (per == 60)    return("H1");
   if (per == 240)   return("H4");
   if (per == 1440)  return("D1");
   if (per == 10080) return("W1");
   if (per == 43200) return("MN1");
   return(" ");
  }
//+++======================================================================+++
//+++                   Triline 3 MTF TT [x2x2x3x4x1]                      +++
//+++======================================================================+++   